import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define the grid size
rows, cols = 5, 4

# Define colors for tiles
clear_color = 'lightgreen'
white_color = 'white'
black_color = 'black'

# Define the tile status for the goal state
tile_status = {
    'tile_0-1': 'clear', 'tile_0-2': 'clear', 'tile_0-3': 'clear', 'tile_0-4': 'clear',
    'tile_1-1': 'white', 'tile_1-2': 'black', 'tile_1-3': 'white', 'tile_1-4': 'black',
    'tile_2-1': 'black', 'tile_2-2': 'white', 'tile_2-3': 'black', 'tile_2-4': 'white',
    'tile_3-1': 'white', 'tile_3-2': 'black', 'tile_3-3': 'white', 'tile_3-4': 'black',
    'tile_4-1': 'black', 'tile_4-2': 'white', 'tile_4-3': 'black', 'tile_4-4': 'white',
}

# Draw the tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        status = tile_status[tile_id]
        if status == 'clear':
            color = clear_color
        elif status == 'white':
            color = white_color
        else:  # status == 'black'
            color = black_color
        rect = patches.Rectangle((col, rows-row-1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color='black' if color != black_color else 'white')

# Place the robots below the grid with "no constraints" status
robot1_text = "robot1 (no constraints)"
robot2_text = "robot2 (no constraints)"
ax.text(0.5, -1, robot1_text, ha='center', va='center', fontsize=10, color='black', bbox=dict(facecolor='white', edgecolor='black'))
ax.text(1.5, -1, robot2_text, ha='center', va='center', fontsize=10, color='white', bbox=dict(facecolor='black', edgecolor='black'))

# Set limits and labels
ax.set_xlim(0, cols)
ax.set_ylim(-2, rows)
ax.set_xticks([])
ax.set_yticks([])

# Add legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=white_color, edgecolor='black', label='White Tile'),
    patches.Patch(facecolor=black_color, edgecolor='black', label='Black Tile'),
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('tiles/one_shot/goal_diagram_code/attempts/goal_diagram_attempt_19.png', bbox_inches='tight')
plt.show()